import '../response/income_statistic_response.dart';

class IncomeData {
  double? revenue;
  double? orders;
  double? average;
  DateTime? startTime;
  DateTime? endTime;
  IncomeStatisticResponse? statistic;

  // Konstruktor
  IncomeData({
    this.revenue,
    this.orders,
    this.average,
    this.startTime,
    this.endTime,
    this.statistic,
  });

  // copyWith metodi
  IncomeData copyWith({
    double? revenue,
    double? orders,
    double? average,
    DateTime? startTime,
    DateTime? endTime,
    IncomeStatisticResponse? statistic,
  }) {
    return IncomeData(
      revenue: revenue ?? this.revenue,
      orders: orders ?? this.orders,
      average: average ?? this.average,
      startTime: startTime ?? this.startTime,
      endTime: endTime ?? this.endTime,
      statistic: statistic ?? this.statistic,
    );
  }

  // fromJson metodi
  factory IncomeData.fromJson(Map<String, dynamic> json) {
    return IncomeData(
      revenue: (json['revenue'] as num?)?.toDouble(),
      orders: (json['orders'] as num?)?.toDouble(),
      average: (json['average'] as num?)?.toDouble(),
      startTime: json['startTime'] != null ? DateTime.parse(json['startTime']) : null,
      endTime: json['endTime'] != null ? DateTime.parse(json['endTime']) : null,
      statistic: json['statistic'] != null
          ? IncomeStatisticResponse.fromJson(json['statistic'])
          : null,
    );
  }

  // toJson metodi
  Map<String, dynamic> toJson() {
    return {
      'revenue': revenue,
      'orders': orders,
      'average': average,
      'startTime': startTime?.toIso8601String(),
      'endTime': endTime?.toIso8601String(),
      'statistic': statistic?.toJson(),
    };
  }
}

// StatisticModel ni misol tariqasida yozamiz
